/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.lang.Codec;

public class SimpleSLTokenizer {
    private static final String msg = "Parse error: unexpected end of content at #";
    private String content;
    private int current = 0;
    private static final String illegalFirstChar = "#0123456789:-?";

    public SimpleSLTokenizer(String string) {
        this.content = string;
    }

    public String nextToken() throws Codec.CodecException {
        try {
            this.skipSpaces();
            String string = null;
            char c = this.content.charAt(this.current);
            if (c == ')' || c == '(') {
                string = String.valueOf(c);
            } else {
                int n = this.current;
                string = this.getElement(false);
                this.current = n;
            }
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    public void consumeChar(char c) throws Codec.CodecException {
        try {
            this.skipSpaces();
            if (this.content.charAt(this.current++) != c) {
                throw new Codec.CodecException("Parse error: position " + (this.current - 1) + ", found " + this.content.charAt(this.current - 1) + " while " + c + " was expected [" + this.content.substring(0, this.current) + "]");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    public String getElement() throws Codec.CodecException {
        return this.getElement(true);
    }

    private String getElement(boolean bl) throws Codec.CodecException {
        try {
            String string = null;
            this.skipSpaces();
            if (this.content.charAt(this.current) == '\"') {
                ++this.current;
                StringBuffer stringBuffer = new StringBuffer();
                while (this.content.charAt(this.current) != '\"') {
                    if (this.content.charAt(this.current) == '\\' && this.content.charAt(this.current + 1) == '\"') {
                        ++this.current;
                    }
                    stringBuffer.append(this.content.charAt(this.current));
                    ++this.current;
                }
                ++this.current;
                string = stringBuffer.toString();
            } else {
                string = this.getWord(bl);
            }
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Codec.CodecException(msg + this.current);
        }
    }

    private String getWord(boolean bl) {
        this.skipSpaces();
        int n = this.current;
        char c = this.content.charAt(this.current);
        if (bl && c == ':') {
            ++n;
        }
        while (!this.isSpace(c) && c != ')' && c != '(') {
            c = this.content.charAt(++this.current);
        }
        String string = this.content.substring(n, this.current);
        return string;
    }

    private void skipSpaces() {
        while (this.isSpace(this.content.charAt(this.current))) {
            ++this.current;
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static boolean isAWord(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (illegalFirstChar.indexOf(string.charAt(0)) >= 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"' || c == '(' || c == ')' || c <= ' ' || c >= '\u0080') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String quoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        stringBuffer.append("\"");
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }
}

