/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentManager;
import jade.core.AgentState;
import jade.core.AgentToolkit;
import jade.core.BaseNode;
import jade.core.BehaviourID;
import jade.core.CaseInsensitiveString;
import jade.core.Command;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.LADT;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.MainContainerImpl;
import jade.core.MessageQueue;
import jade.core.NameClashException;
import jade.core.NodeDescriptor;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.Runtime;
import jade.core.Scheduler;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.ServiceManager;
import jade.core.ServiceNotActiveException;
import jade.core.Specifier;
import jade.core.behaviours.Behaviour;
import jade.core.management.AgentManagementSlice;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingSlice;
import jade.core.mobility.AgentMobilitySlice;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.mtp.MTPDescriptor;
import jade.mtp.TransportAddress;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.PerDayFileLogger;
import jade.util.PrintStreamSplitter;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.wrapper.ContainerProxy;

class AgentContainerImpl
implements AgentContainer,
AgentToolkit {
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    protected LADT localAgents;
    protected Profile myProfile;
    protected CommandProcessor myCommandProcessor;
    protected MainContainerImpl myMainContainer;
    protected IMTPManager myIMTPManager;
    private ServiceManager myServiceManager;
    private ServiceFinder myServiceFinder;
    private ResourceManager myResourceManager;
    protected ContainerID myID;
    protected NodeDescriptor myNodeDescriptor;
    protected JADEPrincipal ownerPrincipal;
    protected Credentials ownerCredentials;
    private AID theAMS;
    private AID theDefaultDF;

    AgentContainerImpl() {
    }

    AgentContainerImpl(Profile profile) {
        this.myProfile = profile;
        this.localAgents = new LADT(16);
    }

    jade.wrapper.AgentContainer getContainerController() {
        return this.getContainerController(this.myNodeDescriptor.getOwnerPrincipal(), this.myNodeDescriptor.getOwnerCredentials());
    }

    public jade.wrapper.AgentContainer getContainerController(JADEPrincipal jADEPrincipal, Credentials credentials) {
        return new jade.wrapper.AgentContainer(this.getContainerProxy(jADEPrincipal, credentials), this, this.getPlatformID());
    }

    private ContainerProxy getContainerProxy(final JADEPrincipal jADEPrincipal, final Credentials credentials) {
        return new ContainerProxy(){
            GenericCommand dummyCmd = new GenericCommand(null, null, null);
            {
                this.dummyCmd.setPrincipal(jADEPrincipal);
                this.dummyCmd.setCredentials(credentials);
            }

            public void createAgent(AID aID, String string, Object[] objectArray) throws Throwable {
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                agentManagementSlice.createAgent(aID, string, objectArray, jADEPrincipal, null, false, this.dummyCmd);
            }

            public void killContainer() throws Throwable {
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                agentManagementSlice.exitContainer();
            }

            public MTPDescriptor installMTP(String string, String string2) throws Throwable {
                MessagingSlice messagingSlice = (MessagingSlice)((Object)this.getProxyToLocalSlice("jade.core.messaging.Messaging"));
                return messagingSlice.installMTP(string, string2);
            }

            public void uninstallMTP(String string) throws Throwable {
                MessagingSlice messagingSlice = (MessagingSlice)((Object)this.getProxyToLocalSlice("jade.core.messaging.Messaging"));
                messagingSlice.uninstallMTP(string);
            }

            public void suspendAgent(AID aID) throws Throwable {
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                agentManagementSlice.changeAgentState(aID, 4);
            }

            public void activateAgent(AID aID) throws Throwable {
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                agentManagementSlice.changeAgentState(aID, 2);
            }

            public void killAgent(AID aID) throws Throwable {
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                agentManagementSlice.killAgent(aID, this.dummyCmd);
            }

            public void moveAgent(AID aID, Location location) throws Throwable {
                AgentMobilitySlice agentMobilitySlice = (AgentMobilitySlice)((Object)this.getProxyToLocalSlice("jade.core.mobility.AgentMobility"));
                agentMobilitySlice.moveAgent(aID, location);
            }

            public void cloneAgent(AID aID, Location location, String string) throws Throwable {
                AgentMobilitySlice agentMobilitySlice = (AgentMobilitySlice)((Object)this.getProxyToLocalSlice("jade.core.mobility.AgentMobility"));
                agentMobilitySlice.copyAgent(aID, location, string);
            }

            private Service.SliceProxy getProxyToLocalSlice(String string) throws Throwable {
                Service service = AgentContainerImpl.this.myServiceFinder.findService(string);
                return (Service.SliceProxy)AgentContainerImpl.this.myIMTPManager.createSliceProxy(string, service.getHorizontalInterface(), AgentContainerImpl.this.myIMTPManager.getLocalNode());
            }
        };
    }

    public void initAgent(AID aID, Agent agent, JADEPrincipal jADEPrincipal, Credentials credentials) throws NameClashException, IMTPException, NotFoundException, JADESecurityException {
        agent.setAID(aID);
        agent.setToolkit(this);
        GenericCommand genericCommand = new GenericCommand("Inform-Created", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(agent);
        genericCommand.addParam(jADEPrincipal);
        genericCommand.addParam(credentials);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NameClashException) {
                throw (NameClashException)object;
            }
            if (object instanceof IMTPException) {
                throw (IMTPException)object;
            }
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                ((Throwable)object).printStackTrace();
            }
        }
    }

    public NodeDescriptor getNodeDescriptor() {
        return this.myNodeDescriptor;
    }

    protected void init() throws IMTPException, ProfileException {
        this.myCommandProcessor = this.myProfile.getCommandProcessor();
        this.myIMTPManager = this.myProfile.getIMTPManager();
        this.myIMTPManager.initialize(this.myProfile);
        this.myServiceManager = this.myProfile.getServiceManager();
        this.myServiceFinder = this.myProfile.getServiceFinder();
        BaseNode baseNode = (BaseNode)this.myIMTPManager.getLocalNode();
        baseNode.setCommandProcessor(this.myCommandProcessor);
        baseNode.setServiceManager(this.myServiceManager);
        this.myMainContainer = this.myProfile.getMain();
        AID.setPlatformID(this.myServiceManager.getPlatformName());
        this.theAMS = new AID("ams", false);
        this.theDefaultDF = new AID("df", false);
        this.myResourceManager = this.myProfile.getResourceManager();
        TransportAddress transportAddress = (TransportAddress)this.myIMTPManager.getLocalAddresses().get(0);
        this.myID = new ContainerID(this.myProfile.getParameter("container-name", "No-Name"), transportAddress);
        this.myNodeDescriptor = new NodeDescriptor(this.myID, this.myIMTPManager.getLocalNode());
    }

    protected void startNode() throws IMTPException, ProfileException, ServiceException, JADESecurityException, NotFoundException {
        Object object;
        ArrayList arrayList = new ArrayList();
        ServiceDescriptor serviceDescriptor = this.startService("jade.core.management.AgentManagementService", false);
        arrayList.add(serviceDescriptor);
        serviceDescriptor = this.startService("jade.core.messaging.MessagingService", false);
        arrayList.add(serviceDescriptor);
        List list = this.myProfile.getSpecifiers("services");
        this.myProfile.setSpecifiers("services", list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Specifier)iterator.next();
            String string = ((Specifier)object).getClassName();
            if (!string.equals("jade.core.security.SecurityService") && !string.equals("jade.core.security.permission.PermissionService")) continue;
            serviceDescriptor = this.startService(string, false);
            arrayList.add(serviceDescriptor);
        }
        object = new ServiceDescriptor[arrayList.size()];
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (ServiceDescriptor)arrayList.get(n);
            ++n;
        }
        this.myServiceManager.addNode(this.myNodeDescriptor, (ServiceDescriptor[])object);
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            ((ServiceDescriptor)object[n2]).getService().boot(this.myProfile);
            ++n2;
        }
        if (this.myMainContainer != null) {
            boolean bl = this.myProfile.getParameter("backupmain", null) == null;
            this.myMainContainer.initSystemAgents(this, bl);
        }
    }

    protected void startAdditionalServices() {
        try {
            List list = this.myProfile.getSpecifiers("services");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Specifier specifier = null;
                try {
                    specifier = (Specifier)iterator.next();
                    String string = specifier.getClassName();
                    if (string.equals("jade.core.security.SecurityService") || string.equals("jade.core.security.permission.PermissionService")) continue;
                    this.startService(string, true);
                }
                catch (Exception exception) {
                    System.out.println("Error starting service " + specifier.getClassName());
                    exception.printStackTrace();
                }
            }
        }
        catch (ProfileException profileException) {
            System.out.println("Error reading services from profile.");
            profileException.printStackTrace();
        }
    }

    boolean joinPlatform() {
        String string = this.myProfile.getParameter("output", null);
        if (string != null) {
            try {
                PerDayFileLogger perDayFileLogger = new PerDayFileLogger(string);
                PrintStreamSplitter printStreamSplitter = new PrintStreamSplitter(System.out, perDayFileLogger);
                System.setOut(printStreamSplitter);
                System.setErr(printStreamSplitter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.init();
            this.startNode();
        }
        catch (IMTPException iMTPException) {
            this.myLogger.log(Logger.SEVERE, "Communication failure while joining agent platform: " + iMTPException.getMessage());
            iMTPException.printStackTrace();
            this.endContainer();
            return false;
        }
        catch (JADESecurityException jADESecurityException) {
            this.myLogger.log(Logger.SEVERE, "Authentication or authorization failure while joining agent platform.");
            jADESecurityException.printStackTrace();
            this.endContainer();
            return false;
        }
        catch (Exception exception) {
            this.myLogger.log(Logger.SEVERE, "Some problem occurred while joining agent platform.");
            exception.printStackTrace();
            this.endContainer();
            return false;
        }
        this.startAdditionalServices();
        this.startBootstrapAgents();
        this.myLogger.log(Logger.INFO, "--------------------------------------\nAgent container " + this.myID + " is ready.\n--------------------------------------------");
        return true;
    }

    private void startBootstrapAgents() {
        try {
            Object object;
            List list = this.myProfile.getSpecifiers("agents");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Specifier)iterator.next();
                if (((Specifier)object).getName() != null) {
                    AID aID = new AID(((Specifier)object).getName(), false);
                    try {
                        this.getContainerProxy(this.myNodeDescriptor.getOwnerPrincipal(), this.myNodeDescriptor.getOwnerCredentials()).createAgent(aID, ((Specifier)object).getClassName(), ((Specifier)object).getArgs());
                    }
                    catch (Throwable throwable) {
                        if (!this.myLogger.isLoggable(Logger.SEVERE)) continue;
                        this.myLogger.log(Logger.SEVERE, "Cannot create agent " + ((Specifier)object).getName() + ": " + throwable.getMessage());
                    }
                    continue;
                }
                this.myLogger.log(Logger.WARNING, "Cannot create an agent with no name");
            }
            object = this.localAgents.keys();
            int n = 0;
            while (n < ((Object)object).length) {
                Object object2 = object[n];
                if (!((AID)object2).equals(this.theAMS) && !((AID)object2).equals(this.theDefaultDF)) {
                    try {
                        this.powerUpLocalAgent((AID)object2);
                    }
                    catch (NotFoundException notFoundException) {
                        notFoundException.printStackTrace();
                    }
                }
                ++n;
            }
        }
        catch (ProfileException profileException) {
            System.out.println("Warning: error reading initial agents");
        }
    }

    public void shutDown() {
        Agent[] agentArray = this.localAgents.values();
        int n = 0;
        while (n < agentArray.length) {
            Agent agent = agentArray[n];
            AID aID = agent.getAID();
            if (!aID.equals(this.getAMS()) && !aID.equals(this.getDefaultDF())) {
                agent.doDelete();
                agent.join();
                agent.resetToolkit();
            }
            ++n;
        }
        try {
            this.myServiceManager.removeNode(this.myNodeDescriptor);
            this.myIMTPManager.shutDown();
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
        this.myResourceManager.releaseResources();
        this.endContainer();
    }

    private void endContainer() {
        try {
            Runtime.instance().endContainer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Location here() {
        return this.myID;
    }

    public void handleSend(ACLMessage aCLMessage, AID aID, boolean bl) {
        Iterator iterator = aCLMessage.getAllIntendedReceiver();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            AID aID2 = (AID)iterator.next();
            if (bl2) {
                bl = bl || iterator.hasNext();
                bl2 = false;
            }
            GenericCommand genericCommand = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
            genericCommand.addParam(aID);
            ACLMessage aCLMessage2 = null;
            aCLMessage2 = bl ? (ACLMessage)aCLMessage.clone() : aCLMessage;
            bl2 = false;
            GenericMessage genericMessage = new GenericMessage(aCLMessage2);
            genericCommand.addParam(genericMessage);
            genericCommand.addParam(aID2);
            this.initCredentials(genericCommand, aID);
            Object object = this.myCommandProcessor.processOutgoing(genericCommand);
            if (object == null || !(object instanceof Throwable)) continue;
            genericCommand = new GenericCommand("Notify-Failure", "jade.core.messaging.Messaging", null);
            genericCommand.addParam(genericMessage);
            genericCommand.addParam(aID2);
            genericCommand.addParam(new InternalError("Message blocked: " + object));
            object = this.myCommandProcessor.processOutgoing(genericCommand);
            if (object == null || !(object instanceof Throwable)) continue;
            ((Throwable)object).printStackTrace();
        }
    }

    public void handlePosted(AID aID, ACLMessage aCLMessage) {
        GenericCommand genericCommand = new GenericCommand("Notify-Posted", "jade.core.event.Notification", null);
        genericCommand.addParam(aCLMessage);
        genericCommand.addParam(aID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void handleReceived(AID aID, ACLMessage aCLMessage) {
        GenericCommand genericCommand = new GenericCommand("Notify-Received", "jade.core.event.Notification", null);
        genericCommand.addParam(aCLMessage);
        genericCommand.addParam(aID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void handleBehaviourAdded(AID aID, Behaviour behaviour) {
        GenericCommand genericCommand = new GenericCommand("Notify-BehaviourAdded", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(behaviour);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void handleBehaviourRemoved(AID aID, Behaviour behaviour) {
        GenericCommand genericCommand = new GenericCommand("Notify-Behaviour-Removed", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(behaviour);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void handleChangeBehaviourState(AID aID, Behaviour behaviour, String string, String string2) {
        GenericCommand genericCommand = new GenericCommand("Notify-Changed-Behaviour-State", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(behaviour);
        genericCommand.addParam(string);
        genericCommand.addParam(string2);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void handleChangedAgentPrincipal(AID aID, JADEPrincipal jADEPrincipal, Credentials credentials) {
    }

    public void handleChangedAgentState(AID aID, int n, int n2) {
        AgentState agentState = AgentState.getInstance(n);
        AgentState agentState2 = AgentState.getInstance(n2);
        GenericCommand genericCommand = new GenericCommand("Inform-State-Changed", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(agentState);
        genericCommand.addParam(agentState2);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void handleEnd(AID aID) {
        GenericCommand genericCommand = new GenericCommand("Inform-Killed", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        this.initCredentials(genericCommand, aID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void setPlatformAddresses(AID aID) {
        GenericCommand genericCommand = new GenericCommand("Set-Platform-Addresses", "jade.core.messaging.Messaging", null);
        genericCommand.addParam(aID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public AID getAMS() {
        return (AID)this.theAMS.clone();
    }

    public AID getDefaultDF() {
        return (AID)this.theDefaultDF.clone();
    }

    public String getProperty(String string, String string2) {
        return this.myProfile.getParameter(string, string2);
    }

    public ServiceHelper getHelper(Agent agent, String string) throws ServiceException {
        try {
            Service service = this.myServiceFinder.findService(string);
            if (service == null) {
                throw new ServiceNotActiveException(string);
            }
            return service.getHelper(agent);
        }
        catch (IMTPException iMTPException) {
            throw new ServiceException(" ServiceHelper could not be created for: " + string, iMTPException);
        }
    }

    public String getPlatformID() {
        return AID.getPlatformID();
    }

    public Agent addLocalAgent(AID aID, Agent agent) {
        agent.setToolkit(this);
        return this.localAgents.put(aID, agent);
    }

    public void powerUpLocalAgent(AID aID) throws NotFoundException {
        Agent agent = this.localAgents.acquire(aID);
        if (agent == null) {
            throw new NotFoundException("powerUpLocalAgent() failed to find agent " + aID.getName());
        }
        Thread thread = this.myResourceManager.getThread(0, aID.getLocalName(), agent);
        agent.powerUp(aID, thread);
        this.localAgents.release(aID);
    }

    public void removeLocalAgent(AID aID) {
        this.localAgents.remove(aID);
    }

    public Agent acquireLocalAgent(AID aID) {
        return this.localAgents.acquire(aID);
    }

    public void releaseLocalAgent(AID aID) {
        this.localAgents.release(aID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillListFromMessageQueue(List list, Agent agent) {
        MessageQueue messageQueue;
        MessageQueue messageQueue2 = messageQueue = agent.getMessageQueue();
        synchronized (messageQueue2) {
            Iterator iterator = messageQueue.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillListFromReadyBehaviours(List list, Agent agent) {
        Scheduler scheduler;
        Scheduler scheduler2 = scheduler = agent.getScheduler();
        synchronized (scheduler2) {
            Iterator iterator = scheduler.readyBehaviours.iterator();
            while (iterator.hasNext()) {
                Behaviour behaviour = (Behaviour)iterator.next();
                list.add(new BehaviourID(behaviour));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillListFromBlockedBehaviours(List list, Agent agent) {
        Scheduler scheduler;
        Scheduler scheduler2 = scheduler = agent.getScheduler();
        synchronized (scheduler2) {
            Iterator iterator = scheduler.blockedBehaviours.iterator();
            while (iterator.hasNext()) {
                Behaviour behaviour = (Behaviour)iterator.next();
                list.add(new BehaviourID(behaviour));
            }
        }
    }

    public void addAddressToLocalAgents(String string) {
        Agent[] agentArray = this.localAgents.values();
        int n = 0;
        while (n < agentArray.length) {
            agentArray[n].addPlatformAddress(string);
            ++n;
        }
        this.theAMS.addAddresses(string);
        this.theDefaultDF.addAddresses(string);
    }

    public void removeAddressFromLocalAgents(String string) {
        Agent[] agentArray = this.localAgents.values();
        int n = 0;
        while (n < agentArray.length) {
            agentArray[n].removePlatformAddress(string);
            ++n;
        }
        this.theAMS.removeAddresses(string);
        this.theDefaultDF.removeAddresses(string);
    }

    public boolean postMessageToLocalAgent(ACLMessage aCLMessage, AID aID) {
        Agent agent = this.localAgents.acquire(aID);
        if (agent == null) {
            return false;
        }
        agent.postMessage(aCLMessage);
        this.localAgents.release(aID);
        return true;
    }

    public boolean livesHere(AID aID) {
        String string = aID.getHap();
        return CaseInsensitiveString.equalsIgnoreCase(string, AID.getPlatformID());
    }

    public ContainerID getID() {
        return this.myID;
    }

    public MainContainer getMain() {
        return this.myMainContainer;
    }

    public ServiceManager getServiceManager() {
        return this.myServiceManager;
    }

    public ServiceFinder getServiceFinder() {
        return this.myServiceFinder;
    }

    protected ServiceDescriptor startService(String string, boolean bl) throws ServiceException {
        try {
            Class<?> clazz = Class.forName(string);
            Service service = (Service)clazz.newInstance();
            service.init(this, this.myProfile);
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor(service.getName(), service);
            if (bl) {
                this.myServiceManager.activateService(serviceDescriptor);
                service.boot(this.myProfile);
            }
            return serviceDescriptor;
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (Throwable throwable) {
            throw new ServiceException("An error occurred during service activation", throwable);
        }
    }

    public void becomeLeader() {
        try {
            this.myMainContainer.startSystemAgents(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addPlatformListener(AgentManager.Listener listener) throws ClassCastException {
        MainContainerImpl mainContainerImpl = this.myMainContainer;
        mainContainerImpl.addListener(listener);
    }

    public void removePlatformListener(AgentManager.Listener listener) throws ClassCastException {
        MainContainerImpl mainContainerImpl = this.myMainContainer;
        mainContainerImpl.removeListener(listener);
    }

    private void initCredentials(Command command, AID aID) {
        Agent agent = this.localAgents.acquire(aID);
        if (agent != null) {
            try {
                CredentialsHelper credentialsHelper = (CredentialsHelper)((Object)agent.getHelper("jade.core.security.Security"));
                command.setPrincipal(credentialsHelper.getPrincipal());
                command.setCredentials(credentialsHelper.getCredentials());
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        this.localAgents.release(aID);
    }
}

