/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.CallbackInvokator;
import jade.core.CommandProcessor;
import jade.core.Filter;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

public abstract class BaseService
implements Service {
    public static final String MAIN_SLICE = "$$$Main-Slice$$$";
    public static final String THIS_SLICE = "$$$This-Slice$$$";
    private ServiceFinder myFinder;
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor = null;
    private Map slices;
    private Map aliases;
    protected Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        this.myFinder = profile.getServiceFinder();
        this.myIMTPManager = profile.getIMTPManager();
        this.slices = new HashMap(5);
        this.aliases = new HashMap(1);
        this.myLogger.log(Logger.INFO, "Service " + this.getName() + " initialized");
    }

    void setCommandProcessor(CommandProcessor commandProcessor) {
        if (this.myCommandProcessor == null) {
            this.myCommandProcessor = commandProcessor;
        }
    }

    public Service.Slice getSlice(String string) throws ServiceException {
        String string2 = this.lookupAlias(string);
        Service.Slice slice = (Service.Slice)this.slices.get(string2);
        if (slice == null) {
            try {
                slice = this.myFinder.findSlice(this.getName(), string2);
                this.slices.put(string2, slice);
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("IMTP Error while using the Service Finder", iMTPException);
            }
        }
        return slice;
    }

    public int getNumberOfSlices() {
        return this.slices.size();
    }

    public Node getLocalNode() throws IMTPException {
        return this.myIMTPManager.getLocalNode();
    }

    public Service.Slice[] getAllSlices() throws ServiceException {
        try {
            return this.myFinder.findAllSlices(this.getName());
        }
        catch (IMTPException iMTPException) {
            throw new ServiceException("IMTP Error while using the Service Finder", iMTPException);
        }
    }

    protected void addAlias(String string, String string2) {
        this.aliases.put(string, string2);
    }

    protected String lookupAlias(String string) {
        String string2 = (String)this.aliases.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public Filter getCommandFilter(boolean bl) {
        return null;
    }

    public Sink getCommandSink(boolean bl) {
        return null;
    }

    public String[] getOwnedCommands() {
        return null;
    }

    public Class getHorizontalInterface() {
        return null;
    }

    public Service.Slice getLocalSlice() {
        return null;
    }

    public ServiceHelper getHelper(Agent agent) {
        return null;
    }

    public Behaviour getAMSBehaviour() {
        return null;
    }

    public void boot(Profile profile) throws ServiceException {
    }

    public void shutdown() {
    }

    public Object submit(VerticalCommand verticalCommand) throws ServiceException {
        String string = verticalCommand.getName();
        String[] stringArray = this.getOwnedCommands();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return this.myCommandProcessor.processOutgoing(verticalCommand);
            }
            ++n;
        }
        throw new ServiceException("Command <" + string + "> does not belong to service <" + this.getName() + ">");
    }

    protected Service.Slice getFreshSlice(String string) throws ServiceException {
        String string2 = this.lookupAlias(string);
        this.slices.remove(string2);
        return this.getSlice(string);
    }

    protected CallbackInvokator createInvokator() {
        return new CallbackInvokator();
    }
}

