/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.VerticalCommand;

public abstract class Filter {
    public static final int FIRST = 0;
    public static final int LAST = 100;
    public static final boolean INCOMING = false;
    public static final boolean OUTGOING = true;
    private boolean blocking = false;
    private boolean skipping = false;
    private Filter next;
    private String myServiceName;
    int preferredPosition = 100;

    final void filter(VerticalCommand verticalCommand) {
        if (this.accept(verticalCommand)) {
            this.next.filter(verticalCommand);
            this.postProcess(verticalCommand);
        }
    }

    protected boolean accept(VerticalCommand verticalCommand) {
        return true;
    }

    protected void postProcess(VerticalCommand verticalCommand) {
    }

    public final int getPreferredPosition() {
        return this.preferredPosition;
    }

    public final void setPreferredPosition(int n) {
        this.preferredPosition = n;
        if (this.preferredPosition > 100) {
            this.preferredPosition = 100;
        } else if (this.preferredPosition < 0) {
            this.preferredPosition = 0;
        }
    }

    public void setBlocking(boolean bl) {
        this.blocking = bl;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setSkipping(boolean bl) {
        this.skipping = bl;
    }

    public boolean isSkipping() {
        return this.skipping;
    }

    final void setServiceName(String string) {
        this.myServiceName = string;
    }

    final void setNext(Filter filter) {
        this.next = filter;
    }

    final Filter getNext() {
        return this.next;
    }
}

