/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentState;
import jade.core.BaseService;
import jade.core.BehaviourID;
import jade.core.Channel;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.core.event.AgentEvent;
import jade.core.event.AgentListener;
import jade.core.event.MessageEvent;
import jade.core.event.MessageListener;
import jade.core.event.NotificationSlice;
import jade.core.messaging.GenericMessage;
import jade.lang.acl.ACLMessage;
import jade.security.JADEPrincipal;
import jade.tools.ToolNotifier;
import jade.util.SynchList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.Serializable;

public class NotificationService
extends BaseService {
    static final String NAME = "jade.core.event.Notification";
    private static final String[] OWNED_COMMANDS = new String[]{"Sniff-On", "Sniff-Off", "Debug-On", "Debug-Off", "Notify-Posted", "Notify-Received", "Notify-Changed-Agent-State", "Notify-Changed-Agent-Principal", "Notify-BehaviourAdded", "Notify-Behaviour-Removed", "Notify-Changed-Behaviour-State"};
    private static final String AMS_DEBUG_HELPER = "AMS-debug-helper";
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private SynchList messageListeners = new SynchList();
    private SynchList agentListeners = new SynchList();
    private Map debuggers = new HashMap();
    static /* synthetic */ Class class$jade$core$event$NotificationSlice;

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myContainer = agentContainer;
        this.localSlice = new ServiceComponent();
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        return class$jade$core$event$NotificationSlice == null ? (class$jade$core$event$NotificationSlice = NotificationService.class$("jade.core.event.NotificationSlice")) : class$jade$core$event$NotificationSlice;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean bl) {
        if (bl) {
            return this.localSlice;
        }
        return null;
    }

    public Sink getCommandSink(boolean bl) {
        return null;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    private void fireSentMessage(ACLMessage aCLMessage, AID aID, AID aID2) {
        List list = this.messageListeners.startScanning();
        if (list != null) {
            MessageEvent messageEvent = new MessageEvent(1, aCLMessage, aID, aID2, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.sentMessage(messageEvent);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void firePostedMessage(ACLMessage aCLMessage, AID aID) {
        List list = this.messageListeners.startScanning();
        if (list != null) {
            MessageEvent messageEvent = new MessageEvent(2, aCLMessage, null, aID, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.postedMessage(messageEvent);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void fireReceivedMessage(ACLMessage aCLMessage, AID aID) {
        List list = this.messageListeners.startScanning();
        if (list != null) {
            MessageEvent messageEvent = new MessageEvent(3, aCLMessage, null, aID, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.receivedMessage(messageEvent);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void fireRoutedMessage(ACLMessage aCLMessage, Channel channel, Channel channel2) {
        List list = this.messageListeners.startScanning();
        if (list != null) {
            MessageEvent messageEvent = new MessageEvent(4, aCLMessage, channel, channel2, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.routedMessage(messageEvent);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void fireAddedBehaviour(AID aID, Behaviour behaviour) {
        List list = this.agentListeners.startScanning();
        if (list != null) {
            AgentEvent agentEvent = null;
            if (behaviour == behaviour.root()) {
                agentEvent = new AgentEvent(2, aID, new BehaviourID(behaviour), this.myID());
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgentListener agentListener = (AgentListener)iterator.next();
                agentListener.addedBehaviour(agentEvent);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireRemovedBehaviour(AID aID, Behaviour behaviour) {
        List list = this.agentListeners.startScanning();
        if (list != null) {
            AgentEvent agentEvent = new AgentEvent(3, aID, new BehaviourID(behaviour), this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgentListener agentListener = (AgentListener)iterator.next();
                agentListener.removedBehaviour(agentEvent);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireChangedBehaviourState(AID aID, Behaviour behaviour, String string, String string2) {
        List list = this.agentListeners.startScanning();
        if (list != null) {
            AgentEvent agentEvent = new AgentEvent(4, aID, new BehaviourID(behaviour), string, string2, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgentListener agentListener = (AgentListener)iterator.next();
                agentListener.changedBehaviourState(agentEvent);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireChangedAgentPrincipal(AID aID, JADEPrincipal jADEPrincipal, JADEPrincipal jADEPrincipal2) {
        List list = this.agentListeners.startScanning();
        if (list != null) {
            AgentEvent agentEvent = new AgentEvent(5, aID, jADEPrincipal, jADEPrincipal2, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgentListener agentListener = (AgentListener)iterator.next();
                agentListener.changedAgentPrincipal(agentEvent);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireChangedAgentState(AID aID, AgentState agentState, AgentState agentState2) {
        List list = this.agentListeners.startScanning();
        if (list != null) {
            AgentEvent agentEvent = new AgentEvent(1, aID, agentState, agentState2, this.myID());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgentListener agentListener = (AgentListener)iterator.next();
                agentListener.changedAgentState(agentEvent);
            }
            this.agentListeners.stopScanning();
        }
    }

    private ToolNotifier findNotifier(AID aID) {
        Agent agent = null;
        List list = this.messageListeners.startScanning();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ToolNotifier toolNotifier;
                AID aID2;
                Object e = iterator.next();
                if (!(e instanceof ToolNotifier) || !(aID2 = (toolNotifier = (ToolNotifier)e).getObserver()).equals(aID)) continue;
                agent = toolNotifier;
                break;
            }
            this.messageListeners.stopScanning();
        }
        if (agent != null && agent.getState() == 6) {
            this.removeMessageListener((MessageListener)((Object)agent));
            this.removeAgentListener((AgentListener)((Object)agent));
            agent = null;
        }
        return agent;
    }

    private void addMessageListener(MessageListener messageListener) {
        List list = this.messageListeners.startModifying();
        list.add(messageListener);
        this.messageListeners.stopModifying();
    }

    private void removeMessageListener(MessageListener messageListener) {
        List list = this.messageListeners.startModifying();
        list.remove(messageListener);
        this.messageListeners.stopModifying();
    }

    private void addAgentListener(AgentListener agentListener) {
        List list = this.agentListeners.startModifying();
        list.add(agentListener);
        this.agentListeners.stopModifying();
    }

    private void removeAgentListener(AgentListener agentListener) {
        List list = this.agentListeners.startModifying();
        list.remove(agentListener);
        this.agentListeners.stopModifying();
    }

    private ContainerID myID() {
        return (ContainerID)this.myContainer.here();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ServiceComponent
    extends Filter
    implements NotificationSlice {
        private ServiceComponent() {
        }

        public boolean accept(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Sniff-On")) {
                    this.handleSniffOn(verticalCommand);
                }
                if (string.equals("Sniff-Off")) {
                    this.handleSniffOff(verticalCommand);
                } else if (string.equals("Debug-On")) {
                    this.handleDebugOn(verticalCommand);
                } else if (string.equals("Debug-Off")) {
                    this.handleDebugOff(verticalCommand);
                } else if (string.equals("Send-Message")) {
                    this.handleSendMessage(verticalCommand);
                } else if (string.equals("Notify-Posted")) {
                    this.handleNotifyPosted(verticalCommand);
                } else if (string.equals("Notify-Received")) {
                    this.handleNotifyReceived(verticalCommand);
                } else if (string.equals("Inform-State-Changed")) {
                    this.handleNotifyChangedAgentState(verticalCommand);
                } else if (string.equals("Notify-Changed-Agent-Principal")) {
                    this.handleNotifyChangedAgentPrincipal(verticalCommand);
                } else if (string.equals("Notify-BehaviourAdded")) {
                    this.handleNotifyAddedBehaviour(verticalCommand);
                } else if (string.equals("Notify-Behaviour-Removed")) {
                    this.handleNotifyRemovedBehaviour(verticalCommand);
                } else if (string.equals("Notify-Changed-Behaviour-State")) {
                    this.handleNotifyChangedBehaviourState(verticalCommand);
                }
            }
            catch (Throwable throwable) {
                verticalCommand.setReturnValue(throwable);
            }
            return true;
        }

        public void setBlocking(boolean bl) {
        }

        public boolean isBlocking() {
            return false;
        }

        public void setSkipping(boolean bl) {
        }

        public boolean isSkipping() {
            return false;
        }

        public Service getService() {
            return NotificationService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return NotificationService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            try {
                String string = horizontalCommand.getName();
                Object[] objectArray = horizontalCommand.getParams();
                if (string.equals("1")) {
                    AID aID = (AID)objectArray[0];
                    AID aID2 = (AID)objectArray[1];
                    this.sniffOn(aID, aID2);
                } else if (string.equals("2")) {
                    AID aID = (AID)objectArray[0];
                    AID aID3 = (AID)objectArray[1];
                    this.sniffOff(aID, aID3);
                } else if (string.equals("3")) {
                    AID aID = (AID)objectArray[0];
                    AID aID4 = (AID)objectArray[1];
                    this.debugOn(aID, aID4);
                } else if (string.equals("4")) {
                    AID aID = (AID)objectArray[0];
                    AID aID5 = (AID)objectArray[1];
                    this.debugOff(aID, aID5);
                }
            }
            catch (Throwable throwable) {
                horizontalCommand.setReturnValue(throwable);
            }
            if (horizontalCommand instanceof VerticalCommand) {
                return (VerticalCommand)((Object)horizontalCommand);
            }
            return null;
        }

        public void sniffOn(AID aID, AID aID2) throws IMTPException {
            ToolNotifier toolNotifier = NotificationService.this.findNotifier(aID);
            if (toolNotifier == null) {
                toolNotifier = new ToolNotifier(aID);
                AID aID3 = new AID(aID.getLocalName() + "-on-" + NotificationService.this.myID().getName(), false);
                try {
                    NotificationService.this.myContainer.initAgent(aID3, toolNotifier, null, null);
                    NotificationService.this.myContainer.powerUpLocalAgent(aID3);
                    NotificationService.this.addMessageListener(toolNotifier);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            toolNotifier.addObservedAgent(aID2);
        }

        public void sniffOff(AID aID, AID aID2) throws IMTPException {
            ToolNotifier toolNotifier = NotificationService.this.findNotifier(aID);
            if (toolNotifier != null) {
                toolNotifier.removeObservedAgent(aID2);
                if (toolNotifier.isEmpty()) {
                    NotificationService.this.removeMessageListener(toolNotifier);
                    toolNotifier.doDelete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debugOn(AID aID, AID aID2) throws IMTPException {
            Serializable serializable;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (aID2.equals(NotificationService.this.myContainer.getAMS()) && !Thread.currentThread().getName().equals(NotificationService.AMS_DEBUG_HELPER)) {
                final AID aID3 = aID;
                final AID aID4 = aID2;
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            this.debugOn(aID3, aID4);
                        }
                        catch (IMTPException iMTPException) {
                            iMTPException.printStackTrace();
                        }
                    }
                });
                thread.setName(NotificationService.AMS_DEBUG_HELPER);
                thread.start();
                return;
            }
            ToolNotifier toolNotifier = NotificationService.this.findNotifier(aID);
            if (toolNotifier == null) {
                toolNotifier = new ToolNotifier(aID);
                object4 = new AID(aID.getLocalName() + "-on-" + NotificationService.this.myID().getName(), false);
                try {
                    NotificationService.this.myContainer.initAgent((AID)object4, toolNotifier, null, null);
                    NotificationService.this.myContainer.powerUpLocalAgent((AID)object4);
                    if (aID2.equals(NotificationService.this.myContainer.getAMS())) {
                        toolNotifier.waitUntilStarted();
                    }
                    NotificationService.this.addMessageListener(toolNotifier);
                    NotificationService.this.addAgentListener(toolNotifier);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            toolNotifier.addObservedAgent(aID2);
            object4 = NotificationService.this.debuggers;
            synchronized (object4) {
                object3 = (List)NotificationService.this.debuggers.get(aID2);
                if (object3 == null) {
                    object3 = new LinkedList();
                    NotificationService.this.debuggers.put(aID2, object3);
                }
                if (!object3.contains(aID)) {
                    object3.add(aID);
                }
            }
            object3 = NotificationService.this.myContainer.acquireLocalAgent(aID2);
            ((Agent)object3).setGenerateBehaviourEvents(true);
            AgentState agentState = ((Agent)object3).getAgentState();
            LinkedList linkedList = new LinkedList();
            NotificationService.this.myContainer.fillListFromMessageQueue(linkedList, (Agent)object3);
            LinkedList linkedList2 = new LinkedList();
            NotificationService.this.myContainer.fillListFromReadyBehaviours(linkedList2, (Agent)object3);
            LinkedList linkedList3 = new LinkedList();
            NotificationService.this.myContainer.fillListFromBlockedBehaviours(linkedList3, (Agent)object3);
            NotificationService.this.myContainer.releaseLocalAgent(aID2);
            NotificationService.this.fireChangedAgentState(aID2, agentState, agentState);
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                object2 = (BehaviourID)iterator.next();
                object = new AgentEvent(2, aID2, (BehaviourID)object2, NotificationService.this.myContainer.getID());
                toolNotifier.addedBehaviour((AgentEvent)object);
            }
            object2 = linkedList3.iterator();
            while (object2.hasNext()) {
                object = (BehaviourID)object2.next();
                serializable = new AgentEvent(2, aID2, (BehaviourID)object, NotificationService.this.myContainer.getID());
                toolNotifier.addedBehaviour((AgentEvent)serializable);
                serializable = new AgentEvent(4, aID2, (BehaviourID)object, "READY", "BLOCKED", NotificationService.this.myContainer.getID());
                toolNotifier.changedBehaviourState((AgentEvent)serializable);
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                serializable = (ACLMessage)object.next();
                MessageEvent messageEvent = new MessageEvent(2, (ACLMessage)serializable, null, aID2, NotificationService.this.myContainer.getID());
                toolNotifier.postedMessage(messageEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debugOff(AID aID, AID aID2) throws IMTPException {
            Object object;
            ToolNotifier toolNotifier = NotificationService.this.findNotifier(aID);
            if (toolNotifier != null) {
                toolNotifier.removeObservedAgent(aID2);
                if (toolNotifier.isEmpty()) {
                    NotificationService.this.removeMessageListener(toolNotifier);
                    NotificationService.this.removeAgentListener(toolNotifier);
                    toolNotifier.doDelete();
                }
            }
            boolean bl = true;
            Map map = NotificationService.this.debuggers;
            synchronized (map) {
                object = (List)NotificationService.this.debuggers.get(aID2);
                if (object != null) {
                    object.remove(aID);
                    if (object.size() > 0) {
                        bl = false;
                    } else {
                        NotificationService.this.debuggers.remove(aID2);
                    }
                }
            }
            if (bl) {
                object = NotificationService.this.myContainer.acquireLocalAgent(aID2);
                if (object != null) {
                    ((Agent)object).setGenerateBehaviourEvents(false);
                }
                NotificationService.this.myContainer.releaseLocalAgent(aID2);
            }
        }

        private void handleSniffOn(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            List list = (List)objectArray[1];
            MainContainer mainContainer = NotificationService.this.myContainer.getMain();
            if (mainContainer != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AID aID2 = (AID)iterator.next();
                    ContainerID containerID = mainContainer.getContainerID(aID2);
                    NotificationSlice notificationSlice = (NotificationSlice)NotificationService.this.getSlice(containerID.getName());
                    try {
                        notificationSlice.sniffOn(aID, aID2);
                    }
                    catch (IMTPException iMTPException) {
                        notificationSlice = (NotificationSlice)NotificationService.this.getFreshSlice(containerID.getName());
                        notificationSlice.sniffOn(aID, aID2);
                    }
                }
            }
        }

        private void handleSniffOff(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            List list = (List)objectArray[1];
            MainContainer mainContainer = NotificationService.this.myContainer.getMain();
            if (mainContainer != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AID aID2 = (AID)iterator.next();
                    ContainerID containerID = mainContainer.getContainerID(aID2);
                    NotificationSlice notificationSlice = (NotificationSlice)NotificationService.this.getSlice(containerID.getName());
                    try {
                        notificationSlice.sniffOff(aID, aID2);
                    }
                    catch (IMTPException iMTPException) {
                        notificationSlice = (NotificationSlice)NotificationService.this.getFreshSlice(containerID.getName());
                        notificationSlice.sniffOff(aID, aID2);
                    }
                }
            }
        }

        private void handleDebugOn(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            List list = (List)objectArray[1];
            MainContainer mainContainer = NotificationService.this.myContainer.getMain();
            if (mainContainer != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AID aID2 = (AID)iterator.next();
                    ContainerID containerID = mainContainer.getContainerID(aID2);
                    NotificationSlice notificationSlice = (NotificationSlice)NotificationService.this.getSlice(containerID.getName());
                    try {
                        notificationSlice.debugOn(aID, aID2);
                    }
                    catch (IMTPException iMTPException) {
                        notificationSlice = (NotificationSlice)NotificationService.this.getFreshSlice(containerID.getName());
                        notificationSlice.debugOn(aID, aID2);
                    }
                }
            }
        }

        private void handleDebugOff(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            List list = (List)objectArray[1];
            MainContainer mainContainer = NotificationService.this.myContainer.getMain();
            if (mainContainer != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AID aID2 = (AID)iterator.next();
                    ContainerID containerID = mainContainer.getContainerID(aID2);
                    NotificationSlice notificationSlice = (NotificationSlice)NotificationService.this.getSlice(containerID.getName());
                    try {
                        notificationSlice.debugOff(aID, aID2);
                    }
                    catch (IMTPException iMTPException) {
                        notificationSlice = (NotificationSlice)NotificationService.this.getFreshSlice(containerID.getName());
                        notificationSlice.debugOff(aID, aID2);
                    }
                }
            }
        }

        private void handleSendMessage(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            ACLMessage aCLMessage = ((GenericMessage)objectArray[1]).getACLMessage();
            AID aID2 = (AID)objectArray[2];
            NotificationService.this.fireSentMessage(aCLMessage, aID, aID2);
        }

        private void handleNotifyPosted(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            ACLMessage aCLMessage = (ACLMessage)objectArray[0];
            AID aID = (AID)objectArray[1];
            NotificationService.this.firePostedMessage(aCLMessage, aID);
        }

        private void handleNotifyReceived(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            ACLMessage aCLMessage = (ACLMessage)objectArray[0];
            AID aID = (AID)objectArray[1];
            NotificationService.this.fireReceivedMessage(aCLMessage, aID);
        }

        private void handleNotifyChangedAgentState(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            AgentState agentState = (AgentState)objectArray[1];
            AgentState agentState2 = (AgentState)objectArray[2];
            NotificationService.this.fireChangedAgentState(aID, agentState, agentState2);
        }

        private void handleNotifyChangedAgentPrincipal(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            JADEPrincipal jADEPrincipal = (JADEPrincipal)objectArray[1];
            JADEPrincipal jADEPrincipal2 = (JADEPrincipal)objectArray[2];
            NotificationService.this.fireChangedAgentPrincipal(aID, jADEPrincipal, jADEPrincipal2);
        }

        private void handleNotifyAddedBehaviour(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            Behaviour behaviour = (Behaviour)objectArray[1];
            NotificationService.this.fireAddedBehaviour(aID, behaviour);
        }

        private void handleNotifyRemovedBehaviour(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            Behaviour behaviour = (Behaviour)objectArray[1];
            NotificationService.this.fireRemovedBehaviour(aID, behaviour);
        }

        private void handleNotifyChangedBehaviourState(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            Behaviour behaviour = (Behaviour)objectArray[1];
            String string = (String)objectArray[2];
            String string2 = (String)objectArray[3];
            NotificationService.this.fireChangedBehaviourState(aID, behaviour, string, string2);
        }
    }
}

