/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Profile;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageStorage;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.StringACLCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import starlight.util.Base64;

class FileMessageStorage
implements MessageStorage {
    private static final String RECEIVER_PREFIX = "AID-";
    private static final String MESSAGE_PREFIX = "MSG-";
    private static final String FOREVER = "FOREVER";
    private File baseDir;

    FileMessageStorage() {
    }

    public void init(Profile profile) {
        String string = profile.getParameter("persistent-delivery-basedir", null);
        if (string == null) {
            string = "." + File.separator + "PersistentDeliveryStore";
        }
        this.baseDir = new File(string);
        if (!this.baseDir.exists()) {
            this.baseDir.mkdir();
        }
    }

    public synchronized String store(GenericMessage genericMessage, AID aID) throws IOException {
        File file = this.getMessageFolder(aID);
        File file2 = this.getMessageFile(file, genericMessage, aID);
        if (file2.exists()) {
            this.incrementCounter(file2);
        } else {
            this.createMessageFile(file2, genericMessage, aID);
        }
        return file2.getName();
    }

    public synchronized void delete(String string, AID aID) throws IOException {
        File file = this.getMessageFolder(aID);
        File file2 = new File(file, string);
        this.decrementCounter(file2);
        if (file.list().length == 0) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loadAll(MessageStorage.LoadListener loadListener) throws IOException {
        loadListener.loadStarted("");
        File[] fileArray = this.baseDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(FileMessageStorage.RECEIVER_PREFIX);
            }
        });
        int n = 0;
        block7: while (true) {
            if (n >= fileArray.length) {
                loadListener.loadEnded("");
                return;
            }
            File file = fileArray[n];
            File[] fileArray2 = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isDirectory() && file.getName().startsWith(FileMessageStorage.MESSAGE_PREFIX);
                }
            });
            int n2 = 0;
            while (true) {
                block12: {
                    Object var20_21;
                    if (n2 >= fileArray2.length) {
                        ++n;
                        continue block7;
                    }
                    File file2 = fileArray2[n2];
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                    String string = bufferedReader.readLine();
                    long l = 1L;
                    try {
                        l = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        try {
                            String string2 = bufferedReader.readLine();
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(string2.toCharArray()));
                            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                            GenericMessage genericMessage = (GenericMessage)objectInputStream.readObject();
                            byteArrayInputStream.close();
                            StringACLCodec stringACLCodec = new StringACLCodec(bufferedReader, null);
                            AID aID = stringACLCodec.decodeAID();
                            int n3 = 0;
                            while ((long)n3 < l) {
                                loadListener.itemLoaded(file2.getName(), genericMessage, aID);
                                ++n3;
                            }
                        }
                        catch (ACLCodec.CodecException codecException) {
                            System.err.println("Error reading file " + file2.getName() + " [" + codecException.getMessage() + "]");
                            var20_21 = null;
                            bufferedReader.close();
                            break block12;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("Error reading file " + file2.getName() + " [" + classNotFoundException.getMessage() + "]");
                            var20_21 = null;
                            bufferedReader.close();
                            break block12;
                        }
                        var20_21 = null;
                    }
                    catch (Throwable throwable) {
                        var20_21 = null;
                        bufferedReader.close();
                        throw throwable;
                    }
                    bufferedReader.close();
                }
                ++n2;
            }
            break;
        }
    }

    private File getMessageFolder(AID aID) throws IOException {
        String string = RECEIVER_PREFIX + aID.hashCode();
        File file = new File(this.baseDir, string);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private File getMessageFile(File file, GenericMessage genericMessage, AID aID) throws IOException {
        long l = aID.hashCode();
        long l2 = genericMessage.toString().hashCode();
        String string = MESSAGE_PREFIX + (l * 2L + l2);
        File file2 = new File(file, string);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void incrementCounter(File file) throws IOException {
        File file2;
        block10: {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            file2 = File.createTempFile("JADE", ".tmp");
            String string = bufferedReader.readLine();
            try {
                try {
                    long l = Long.parseLong(string);
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                    try {
                        string = Long.toString(++l);
                        bufferedWriter.write(string, 0, string.length());
                        bufferedWriter.newLine();
                        string = bufferedReader.readLine();
                        while (true) {
                            if (string == null) {
                                Object var9_8 = null;
                                break;
                            }
                            bufferedWriter.write(string, 0, string.length());
                            bufferedWriter.newLine();
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        bufferedWriter.close();
                        throw throwable;
                    }
                    bufferedWriter.close();
                    Object var11_11 = null;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    Object var11_12 = null;
                    bufferedReader.close();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
        }
        file.delete();
        file2.renameTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementCounter(File file) throws IOException {
        block6: {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            File file2 = File.createTempFile("JADE", ".tmp");
            String string = bufferedReader.readLine();
            try {
                long l = Long.parseLong(string);
                if (--l == 0L) {
                    bufferedReader.close();
                    file.delete();
                    break block6;
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                try {
                    string = Long.toString(l);
                    bufferedWriter.write(string, 0, string.length());
                    bufferedWriter.newLine();
                    string = bufferedReader.readLine();
                    while (string != null) {
                        bufferedWriter.write(string, 0, string.length());
                        bufferedWriter.newLine();
                        string = bufferedReader.readLine();
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    bufferedReader.close();
                    bufferedWriter.close();
                    throw throwable;
                }
                bufferedReader.close();
                bufferedWriter.close();
                file.delete();
                file2.renameTo(file);
            }
            catch (NumberFormatException numberFormatException) {
                bufferedReader.close();
                numberFormatException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createMessageFile(File file, GenericMessage genericMessage, AID aID) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            file.createNewFile();
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("1", 0, 1);
            bufferedWriter.newLine();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(genericMessage);
            String string = new String(Base64.encode(byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream.close();
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            String string2 = aID.toString();
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            Object var10_9 = null;
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bufferedWriter == null) throw throwable;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
    }
}

