/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.UnreachableException;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.OutBox;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;

class MessageManager {
    private static MessageManager theInstance;
    private static final int POOL_SIZE_DEFAULT = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_QUEUE_SIZE_DEFAULT = 10000000;
    private OutBox outBox;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private MessageManager() {
    }

    public static synchronized MessageManager instance(Profile profile) {
        if (theInstance == null) {
            theInstance = new MessageManager();
            theInstance.initialize(profile);
        }
        return theInstance;
    }

    public void initialize(Profile profile) {
        Object object;
        int n = 5;
        try {
            String string = profile.getParameter("jade_core_messaging_MessageManager_poolsize", null);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 10000000;
        try {
            object = profile.getParameter("jade_core_messaging_MessageManager_maxqueuesize", null);
            n2 = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.outBox = new OutBox(n2);
        try {
            object = profile.getResourceManager();
            int n3 = 0;
            while (n3 < n) {
                String string = "Deliverer-" + n3;
                Thread thread = object.getThread(2, string, new Deliverer());
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Starting deliverer " + string + ". Thread=" + thread);
                }
                thread.start();
                ++n3;
            }
        }
        catch (ProfileException profileException) {
            throw new RuntimeException("Can't get ResourceManager. " + profileException.getMessage());
        }
    }

    public void deliver(GenericMessage genericMessage, AID aID, Channel channel) {
        if (this.myLogger.isLoggable(Logger.FINEST)) {
            this.myLogger.log(Logger.FINEST, "Enqueuing message " + MessageManager.stringify(genericMessage) + " for agent " + aID.getName());
        }
        this.outBox.addLast(aID, genericMessage, channel);
    }

    public static final String stringify(GenericMessage genericMessage) {
        ACLMessage aCLMessage = genericMessage.getACLMessage();
        if (aCLMessage != null) {
            StringBuffer stringBuffer = new StringBuffer("(");
            stringBuffer.append(ACLMessage.getPerformative(aCLMessage.getPerformative()));
            stringBuffer.append(" sender: ");
            stringBuffer.append(aCLMessage.getSender());
            if (aCLMessage.getOntology() != null) {
                stringBuffer.append(" ontology: ");
                stringBuffer.append(aCLMessage.getOntology());
            }
            if (aCLMessage.getConversationId() != null) {
                stringBuffer.append(" conversation-id: ");
                stringBuffer.append(aCLMessage.getConversationId());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        return "unavailable";
    }

    public static class PendingMsg {
        private final GenericMessage msg;
        private final AID receiverID;
        private final Channel channel;
        private long deadline;

        public PendingMsg(GenericMessage genericMessage, AID aID, Channel channel, long l) {
            this.msg = genericMessage;
            this.receiverID = aID;
            this.channel = channel;
            this.deadline = l;
        }

        public GenericMessage getMessage() {
            return this.msg;
        }

        public AID getReceiver() {
            return this.receiverID;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public long getDeadline() {
            return this.deadline;
        }

        public void setDeadline(long l) {
            this.deadline = l;
        }
    }

    class Deliverer
    implements Runnable {
        Deliverer() {
        }

        public void run() {
            while (true) {
                PendingMsg pendingMsg = MessageManager.this.outBox.get();
                GenericMessage genericMessage = pendingMsg.getMessage();
                AID aID = pendingMsg.getReceiver();
                if (MessageManager.this.myLogger.isLoggable(Logger.FINER)) {
                    MessageManager.this.myLogger.log(Logger.FINER, "Serving message " + MessageManager.stringify(genericMessage) + " for agent " + aID.getName());
                }
                Channel channel = pendingMsg.getChannel();
                try {
                    channel.deliverNow(genericMessage, aID);
                    if (MessageManager.this.myLogger.isLoggable(Logger.FINEST)) {
                        MessageManager.this.myLogger.log(Logger.FINEST, "Message served.");
                    }
                }
                catch (Throwable throwable) {
                    MessageManager.this.myLogger.log(Logger.WARNING, "MessageManager cannot deliver message " + MessageManager.stringify(genericMessage) + " to agent " + aID.getName() + ". " + throwable);
                    channel.notifyFailureToSender(genericMessage, aID, new InternalError("\"" + throwable + "\""));
                }
                MessageManager.this.outBox.handleServed(aID);
            }
        }
    }

    public static interface Channel {
        public void deliverNow(GenericMessage var1, AID var2) throws UnreachableException, NotFoundException;

        public void notifyFailureToSender(GenericMessage var1, AID var2, InternalError var3);
    }
}

