/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.core.IMTPException;
import jade.core.Runtime;
import jade.core.messaging.MessagingSlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.mtp.MTP;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.mtp.OutChannel;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;

class RoutingTable {
    private static final boolean LOCAL = true;
    private static final boolean REMOTE = false;
    private final Map inPorts = new HashMap(2);
    private final Map outPorts = new HashMap(2);
    private static final int EXPECTED_PLATFORMADDRESSES_SIZE = 2;
    private final List platformAddresses = new ArrayList(2);
    private String platformInfo = null;

    public RoutingTable(boolean bl) {
        if (bl) {
            this.platformInfo = Runtime.instance().getVersionInfo() + " (" + System.getProperty("java.version") + ", " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
        }
    }

    public synchronized void addLocalMTP(String string, MTP mTP) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        this.inPorts.put(caseInsensitiveString, mTP);
        OutViaMTP outViaMTP = new OutViaMTP(mTP, this.platformInfo);
        String[] stringArray = mTP.getSupportedProtocols();
        int n = 0;
        while (n < stringArray.length) {
            this.addOutPort(stringArray[n], outViaMTP, true);
            ++n;
        }
        this.platformAddresses.add(string);
    }

    public synchronized MTP removeLocalMTP(String string) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        MTP mTP = (MTP)this.inPorts.remove(caseInsensitiveString);
        if (mTP != null) {
            String[] stringArray = mTP.getSupportedProtocols();
            int n = 0;
            while (n < stringArray.length) {
                OutViaMTP outViaMTP = new OutViaMTP(mTP, this.platformInfo);
                this.removeOutPort(stringArray[n], outViaMTP);
                ++n;
            }
        }
        this.platformAddresses.remove(string);
        return mTP;
    }

    public synchronized void addRemoteMTP(MTPDescriptor mTPDescriptor, String string, MessagingSlice messagingSlice) {
        OutViaSlice outViaSlice = new OutViaSlice(string, messagingSlice);
        String[] stringArray = mTPDescriptor.getSupportedProtocols();
        int n = 0;
        while (n < stringArray.length) {
            this.addOutPort(stringArray[n], outViaSlice, false);
            ++n;
        }
        String[] stringArray2 = mTPDescriptor.getAddresses();
        this.platformAddresses.add(stringArray2[0]);
    }

    public synchronized void removeRemoteMTP(MTPDescriptor mTPDescriptor, String string, MessagingSlice messagingSlice) {
        OutViaSlice outViaSlice = new OutViaSlice(string, messagingSlice);
        String[] stringArray = mTPDescriptor.getSupportedProtocols();
        int n = 0;
        while (n < stringArray.length) {
            this.removeOutPort(stringArray[n], outViaSlice);
            ++n;
        }
        String[] stringArray2 = mTPDescriptor.getAddresses();
        this.platformAddresses.remove(stringArray2[0]);
    }

    public synchronized OutPort lookup(String string) {
        String string2 = this.extractProto(string);
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string2);
        OutPortList outPortList = (OutPortList)this.outPorts.get(caseInsensitiveString);
        if (outPortList != null) {
            return outPortList.get();
        }
        return null;
    }

    public synchronized Iterator getAddresses() {
        return this.platformAddresses.iterator();
    }

    private void addOutPort(String string, OutPort outPort, boolean bl) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        OutPortList outPortList = (OutPortList)this.outPorts.get(caseInsensitiveString);
        if (outPortList != null) {
            outPortList.add(outPort, bl);
        } else {
            outPortList = new OutPortList();
            outPortList.add(outPort, bl);
            this.outPorts.put(caseInsensitiveString, outPortList);
        }
    }

    private void removeOutPort(String string, OutPort outPort) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        OutPortList outPortList = (OutPortList)this.outPorts.get(caseInsensitiveString);
        if (outPortList != null) {
            outPortList.remove(outPort);
        }
    }

    private String extractProto(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private static class OutPortList {
        private final List local = new ArrayList(1);
        private final List remote = new ArrayList(1);

        private OutPortList() {
        }

        public void add(OutPort outPort, boolean bl) {
            if (bl) {
                this.local.add(outPort);
            } else {
                this.remote.add(outPort);
            }
        }

        public void remove(OutPort outPort) {
            this.local.remove(outPort);
            this.remote.remove(outPort);
        }

        public OutPort get() {
            if (!this.local.isEmpty()) {
                return (OutPort)this.local.get(0);
            }
            if (!this.remote.isEmpty()) {
                return (OutPort)this.remote.get(0);
            }
            return null;
        }

        public boolean isEmpty() {
            return this.local.isEmpty() && this.remote.isEmpty();
        }

        public String size() {
            return "[ local: " + this.local.size() + "  remote: " + this.remote.size() + " ]";
        }
    }

    private static class OutViaMTP
    implements OutPort {
        private final OutChannel myChannel;
        private String platformInfo;

        public OutViaMTP(OutChannel outChannel, String string) {
            this.myChannel = outChannel;
            this.platformInfo = string;
        }

        public void route(Envelope envelope, byte[] byArray, AID aID, String string) throws MTPException {
            if (this.platformInfo != null) {
                envelope.addProperties(new Property("x-sender-platform-identifer", this.platformInfo));
                envelope.addProperties(new Property("x-sender-mtp-identifer", this.myChannel.getClass().getName()));
            }
            this.myChannel.deliver(string, envelope, byArray);
        }

        public boolean equals(Object object) {
            try {
                OutViaMTP outViaMTP = (OutViaMTP)object;
                OutChannel outChannel = outViaMTP.myChannel;
                return this.myChannel.equals(outChannel);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    private static class OutViaSlice
    implements OutPort {
        private final String sliceName;
        private final MessagingSlice slice;

        public OutViaSlice(String string, MessagingSlice messagingSlice) {
            this.sliceName = string;
            this.slice = messagingSlice;
        }

        public void route(Envelope envelope, byte[] byArray, AID aID, String string) throws MTPException {
            try {
                this.slice.routeOut(envelope, byArray, aID, string);
            }
            catch (IMTPException iMTPException) {
                throw new MTPException("Container unreachable during routing", iMTPException);
            }
        }

        public boolean equals(Object object) {
            try {
                OutViaSlice outViaSlice = (OutViaSlice)object;
                String string = outViaSlice.sliceName;
                return this.sliceName.equals(string);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    public static interface OutPort {
        public void route(Envelope var1, byte[] var2, AID var3, String var4) throws MTPException;
    }
}

