/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.rmi;

import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.imtp.rmi.NodeAdapter;
import jade.imtp.rmi.RMIAddress;
import jade.imtp.rmi.ServiceManagerRMI;
import jade.imtp.rmi.ServiceManagerRMIImpl;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.net.InetAddress;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Vector;

public class RMIIMTPManager
implements IMTPManager {
    private static final String LOCAL_SERVICE_MANAGER_HOST = "smhost";
    public static final String LOCAL_SERVICE_MANAGER_PORT = "smport";
    private static final String LOCAL_NODE_HOST = "nodehost";
    public static final String LOCAL_NODE_PORT = "nodeport";
    private static final int DEFAULT_RMI_PORT = 1099;
    private Profile myProfile;
    private String mainHost;
    private int mainPort;
    private String localHost;
    private int localPort;
    private String localSvcMgrHost;
    private int localSvcMgrPort;
    private String localNodeHost;
    private int localNodePort;
    private String localAddr;
    private String originalPMAddr;
    private NodeAdapter localNode;
    private ServiceManagerRMIImpl myRMIServiceManager;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public void initialize(Profile profile) throws IMTPException {
        this.myProfile = profile;
        this.mainHost = this.myProfile.getParameter("host", null);
        this.mainPort = 1099;
        String string = this.myProfile.getParameter("port", null);
        try {
            this.mainPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.myProfile.getBooleanProperty("main", true) && !this.myProfile.getBooleanProperty("backupmain", false)) {
            this.localHost = this.myProfile.getParameter("local-host", this.mainHost);
            this.localPort = this.mainPort;
        } else {
            this.localHost = this.myProfile.getParameter("local-host", null);
            this.localPort = 1099;
        }
        String string2 = this.myProfile.getParameter("local-port", null);
        try {
            this.localPort = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localSvcMgrHost = this.myProfile.getParameter(LOCAL_SERVICE_MANAGER_HOST, null);
        this.localSvcMgrPort = 0;
        String string3 = this.myProfile.getParameter(LOCAL_SERVICE_MANAGER_PORT, null);
        try {
            this.localSvcMgrPort = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!this.myProfile.getBooleanProperty("main", true)) {
            this.localNodeHost = this.myProfile.getParameter(LOCAL_NODE_HOST, this.localHost);
            this.localNodePort = this.localPort;
        } else {
            this.localNodeHost = this.myProfile.getParameter(LOCAL_NODE_HOST, null);
            this.localNodePort = 0;
        }
        String string4 = this.myProfile.getParameter(LOCAL_NODE_PORT, null);
        try {
            this.localNodePort = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localAddr = "rmi://" + this.localHost + ":" + this.localPort + "/";
        if (this.myProfile.getBooleanProperty("main", true) && this.myProfile.getBooleanProperty("backupmain", false)) {
            this.originalPMAddr = "rmi://" + this.mainHost + ":" + this.mainPort + "/";
        }
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "IMTP parameters: main-host = " + this.mainHost + " main-port = " + this.mainPort + " local-port = " + this.localPort + " sm-port = " + this.localSvcMgrPort + " node-port = " + this.localNodePort);
        }
        try {
            this.localNode = new NodeAdapter("No-Name", this.myProfile.getBooleanProperty("main", true), this.localNodePort, this);
        }
        catch (RemoteException remoteException) {
            throw new IMTPException("An RMI error occurred", remoteException);
        }
    }

    private Registry getRmiRegistry(String string, int n) throws RemoteException {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(string, n);
            registry.list();
        }
        catch (Exception exception) {
            registry = null;
        }
        if (registry == null) {
            registry = LocateRegistry.createRegistry(n);
        }
        return registry;
    }

    public void exportPlatformManager(PlatformManager platformManager) throws IMTPException {
        block7: {
            try {
                String string = this.localAddr + "ServiceManager";
                platformManager.setLocalAddress(this.localAddr);
                this.myRMIServiceManager = new ServiceManagerRMIImpl(platformManager, this, this.localSvcMgrPort);
                Registry registry = this.getRmiRegistry(null, this.localPort);
                Naming.bind(string, this.myRMIServiceManager);
                if (this.originalPMAddr == null) break block7;
                PlatformManager platformManager2 = this.getPlatformManagerProxy(this.originalPMAddr);
                try {
                    ((PlatformManagerImpl)platformManager).setPlatformName(platformManager2.getPlatformName());
                    platformManager.addReplica(this.originalPMAddr, true);
                    platformManager2.addReplica(this.localAddr, false);
                }
                catch (ServiceException serviceException) {
                    throw new IMTPException("Cannot attach to the original PlatformManager.", serviceException);
                }
            }
            catch (ConnectException connectException) {
                System.out.println("ERROR: trying to bind to a remote RMI registry.");
                System.out.println("If you want to start a JADE main container:");
                System.out.println("  Make sure the specified host name or IP address belongs to the local machine.");
                System.out.println("  Please use '-host' and/or '-port' options to setup JADE host and port.");
                System.out.println("If you want to start a JADE non-main container: ");
                System.out.println("  Use the '-container' option, then use '-host' and '-port' to specify the ");
                System.out.println("  location of the main container you want to connect to.");
                throw new IMTPException("RMI Binding error", connectException);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("Communication failure while starting JADE Runtime System. Check if the RMIRegistry CLASSPATH includes the RMI Stub classes of JADE.", remoteException);
            }
            catch (AlreadyBoundException alreadyBoundException) {
                throw new IMTPException("The Service Manager was already bound in the RMI Registry", alreadyBoundException);
            }
            catch (Exception exception) {
                throw new IMTPException("Problem starting JADE Runtime System.", exception);
            }
        }
    }

    public void unexportPlatformManager(PlatformManager platformManager) throws IMTPException {
        if (this.myRMIServiceManager != null && this.myRMIServiceManager.getPlatformManager().equals(platformManager)) {
            try {
                String string = this.localAddr + "ServiceManager";
                Naming.unbind(string);
                ServiceManagerRMIImpl.unexportObject(this.myRMIServiceManager, true);
            }
            catch (Exception exception) {
                throw new IMTPException("Error in unexporting the RMI Service Manager", exception);
            }
        }
    }

    public PlatformManager getPlatformManagerProxy() throws IMTPException {
        return this.getPlatformManagerProxy("rmi://" + this.mainHost + ":" + this.mainPort + "/");
    }

    public PlatformManager getPlatformManagerProxy(String string) throws IMTPException {
        try {
            String string2 = string + "ServiceManager";
            ServiceManagerRMI serviceManagerRMI = (ServiceManagerRMI)Naming.lookup(string2);
            return new PlatformManagerAdapter(serviceManagerRMI, string);
        }
        catch (Exception exception) {
            throw new IMTPException("Can't get a proxy to the PlatformManager at address " + string, exception);
        }
    }

    public void reconnected(PlatformManager platformManager) {
    }

    public Service.Slice createSliceProxy(String string, Class clazz, Node node) throws IMTPException {
        try {
            Class<?> clazz2 = Class.forName(string + "Proxy");
            Service.SliceProxy sliceProxy = (Service.SliceProxy)clazz2.newInstance();
            sliceProxy.setNode(node);
            return sliceProxy;
        }
        catch (Exception exception) {
            throw new IMTPException("Error creating a slice proxy", exception);
        }
    }

    public Node getLocalNode() throws IMTPException {
        return this.localNode;
    }

    public void shutDown() {
        try {
            this.localNode.exit();
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
        }
    }

    public List getLocalAddresses() throws IMTPException {
        try {
            LinkedList linkedList = new LinkedList();
            RMIAddress rMIAddress = new RMIAddress(InetAddress.getLocalHost().getHostName(), String.valueOf(this.localPort), null, null);
            linkedList.add(rMIAddress);
            return linkedList;
        }
        catch (Exception exception) {
            throw new IMTPException("Exception in reading local addresses", exception);
        }
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return null;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return null;
    }

    private class PlatformManagerAdapter
    implements PlatformManager {
        private String localAddress;
        private ServiceManagerRMI adaptee;

        private PlatformManagerAdapter(ServiceManagerRMI serviceManagerRMI, String string) {
            this.localAddress = string;
            this.adaptee = serviceManagerRMI;
        }

        public String getPlatformName() throws IMTPException {
            try {
                return this.adaptee.getPlatformName();
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public String getLocalAddress() {
            return this.localAddress;
        }

        public void setLocalAddress(String string) {
        }

        public String addNode(NodeDescriptor nodeDescriptor, Vector vector, boolean bl) throws IMTPException, ServiceException, JADESecurityException {
            try {
                return this.adaptee.addNode(nodeDescriptor, vector, bl);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void removeNode(NodeDescriptor nodeDescriptor, boolean bl) throws IMTPException, ServiceException {
            try {
                this.adaptee.removeNode(nodeDescriptor, bl);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void addSlice(ServiceDescriptor serviceDescriptor, NodeDescriptor nodeDescriptor, boolean bl) throws IMTPException, ServiceException {
            try {
                this.adaptee.addSlice(serviceDescriptor, nodeDescriptor, bl);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void removeSlice(String string, String string2, boolean bl) throws IMTPException, ServiceException {
            try {
                this.adaptee.removeSlice(string, string2, bl);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void addReplica(String string, boolean bl) throws IMTPException, ServiceException {
            try {
                this.adaptee.addReplica(string, bl);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void removeReplica(String string, boolean bl) throws IMTPException, ServiceException {
            try {
                this.adaptee.removeReplica(string, bl);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public Service.Slice findSlice(String string, String string2) throws IMTPException, ServiceException {
            try {
                return this.adaptee.findSlice(string, string2);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public Vector findAllSlices(String string) throws IMTPException, ServiceException {
            try {
                return this.adaptee.findAllSlices(string);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void adopt(Node node, Node[] nodeArray) throws IMTPException {
            try {
                this.adaptee.adopt(node, nodeArray);
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }

        public void ping() throws IMTPException {
            try {
                this.adaptee.ping();
            }
            catch (RemoteException remoteException) {
                throw new IMTPException("RMI exception", remoteException);
            }
        }
    }
}

