/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.util.Date;
import java.util.Vector;

public class SimpleAchieveREInitiator
extends SimpleBehaviour {
    private static final int PREPARE_MSG_STATE = 0;
    private static final int SEND_MSG_STATE = 1;
    private static final int RECEIVE_REPLY_STATE = 2;
    private static final int RECEIVE_2ND_REPLY_STATE = 3;
    private static final int ALL_REPLIES_RECEIVED_STATE = 4;
    private static final int ALL_RESULT_NOTIFICATION_RECEIVED_STATE = 5;
    public final String REQUEST_KEY = "_request" + this.hashCode();
    public final String REQUEST_SENT_KEY = "_request_sent" + this.hashCode();
    public final String SECOND_REPLY_KEY = "_2nd_reply" + this.hashCode();
    public final String ALL_RESPONSES_KEY = "_all-responses" + this.hashCode();
    public final String ALL_RESULT_NOTIFICATIONS_KEY = "_all-result-notification" + this.hashCode();
    private MessageTemplate mt = null;
    private int state = 0;
    private boolean finished;
    private long timeout = -1L;
    private long endingTime = 0L;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public SimpleAchieveREInitiator(Agent agent, ACLMessage aCLMessage) {
        this(agent, aCLMessage, new DataStore());
    }

    public SimpleAchieveREInitiator(Agent agent, ACLMessage aCLMessage, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.getDataStore().put(this.REQUEST_KEY, aCLMessage);
        this.finished = false;
    }

    public final void action() {
        block0 : switch (this.state) {
            case 0: {
                ACLMessage aCLMessage = this.prepareRequest((ACLMessage)this.getDataStore().get(this.REQUEST_KEY));
                this.getDataStore().put(this.REQUEST_SENT_KEY, aCLMessage);
                this.state = 1;
                break;
            }
            case 1: {
                Date date;
                DataStore dataStore = this.getDataStore();
                String string = null;
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(this.REQUEST_SENT_KEY);
                if (aCLMessage == null) {
                    this.finished = true;
                    break;
                }
                if (aCLMessage.getConversationId() == null) {
                    string = "C" + this.hashCode() + "_" + System.currentTimeMillis();
                    aCLMessage.setConversationId(string);
                } else {
                    string = aCLMessage.getConversationId();
                }
                this.mt = MessageTemplate.MatchConversationId(string);
                Iterator iterator = aCLMessage.getAllReceiver();
                AID aID = (AID)iterator.next();
                aCLMessage.clearAllReceiver();
                aCLMessage.addReceiver(aID);
                if (iterator.hasNext() && this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "The message you are sending has more than one receivers. The message will be sent only to the first one !!");
                }
                if (aID.equals(this.myAgent.getAID())) {
                    this.mt = MessageTemplate.and(this.mt, MessageTemplate.not(MessageTemplate.MatchCustom(aCLMessage, true)));
                }
                this.timeout = (date = aCLMessage.getReplyByDate()) != null ? date.getTime() - new Date().getTime() : -1L;
                this.endingTime = System.currentTimeMillis() + this.timeout;
                this.myAgent.send(aCLMessage);
                this.state = 2;
                break;
            }
            case 2: {
                ACLMessage aCLMessage = this.myAgent.receive(this.mt);
                if (aCLMessage != null) {
                    DataStore dataStore = this.getDataStore();
                    switch (aCLMessage.getPerformative()) {
                        case 1: {
                            this.state = 3;
                            Vector vector = (Vector)dataStore.get(this.ALL_RESPONSES_KEY);
                            vector.addElement(aCLMessage);
                            this.handleAgree(aCLMessage);
                            this.handleAllResponses((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY));
                            break block0;
                        }
                        case 14: {
                            Vector vector = (Vector)dataStore.get(this.ALL_RESPONSES_KEY);
                            vector.addElement(aCLMessage);
                            this.state = 4;
                            this.handleRefuse(aCLMessage);
                            break block0;
                        }
                        case 10: {
                            Vector vector = (Vector)dataStore.get(this.ALL_RESPONSES_KEY);
                            vector.addElement(aCLMessage);
                            this.state = 4;
                            this.handleNotUnderstood(aCLMessage);
                            break block0;
                        }
                        case 6: {
                            Vector vector = (Vector)dataStore.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            vector.addElement(aCLMessage);
                            this.state = 5;
                            this.handleFailure(aCLMessage);
                            break block0;
                        }
                        case 7: {
                            Vector vector = (Vector)dataStore.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            vector.addElement(aCLMessage);
                            this.state = 5;
                            this.handleInform(aCLMessage);
                            break block0;
                        }
                    }
                    this.state = 2;
                    this.handleOutOfSequence(aCLMessage);
                    break;
                }
                if (this.timeout > 0L) {
                    long l = this.endingTime - System.currentTimeMillis();
                    if (l <= 0L) {
                        this.state = 4;
                        break;
                    }
                    this.block(l);
                    break;
                }
                this.block();
                break;
            }
            case 3: {
                ACLMessage aCLMessage = this.myAgent.receive(this.mt);
                if (aCLMessage != null) {
                    DataStore dataStore = this.getDataStore();
                    switch (aCLMessage.getPerformative()) {
                        case 7: {
                            this.state = 5;
                            Vector vector = (Vector)dataStore.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            vector.addElement(aCLMessage);
                            this.handleInform(aCLMessage);
                            break block0;
                        }
                        case 6: {
                            this.state = 5;
                            Vector vector = (Vector)dataStore.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            vector.addElement(aCLMessage);
                            this.handleFailure(aCLMessage);
                            break block0;
                        }
                    }
                    this.state = 2;
                    this.handleOutOfSequence(aCLMessage);
                    break;
                }
                this.block();
                break;
            }
            case 4: {
                this.state = 5;
                this.handleAllResponses((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY));
                break;
            }
            case 5: {
                this.finished = true;
                this.handleAllResultNotifications((Vector)this.getDataStore().get(this.ALL_RESULT_NOTIFICATIONS_KEY));
                break;
            }
        }
    }

    public void onStart() {
        this.initializeDataStore();
    }

    public boolean done() {
        return this.finished;
    }

    protected ACLMessage prepareRequest(ACLMessage aCLMessage) {
        return aCLMessage;
    }

    protected void handleAgree(ACLMessage aCLMessage) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleAgree: " + aCLMessage.toString());
        }
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleRefuse: " + aCLMessage.toString());
        }
    }

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleNotUnderstood: " + aCLMessage.toString());
        }
    }

    protected void handleInform(ACLMessage aCLMessage) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleInform: " + aCLMessage.toString());
        }
    }

    protected void handleFailure(ACLMessage aCLMessage) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "in HandleFailure: " + aCLMessage.toString());
        }
    }

    protected void handleOutOfSequence(ACLMessage aCLMessage) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "in HandleOutOfSequence: " + aCLMessage.toString());
        }
    }

    protected void handleAllResponses(Vector vector) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, this.myAgent.getName() + "in handleAllResponses: ");
        }
    }

    protected void handleAllResultNotifications(Vector vector) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, this.myAgent.getName() + "in HandleAllResultNotification: ");
        }
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(ACLMessage aCLMessage) {
        this.finished = false;
        this.state = 0;
        this.getDataStore().put(this.REQUEST_KEY, aCLMessage);
        this.initializeDataStore();
        super.reset();
    }

    private void initializeDataStore() {
        Vector vector = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, vector);
        vector = new Vector();
        this.getDataStore().put(this.ALL_RESULT_NOTIFICATIONS_KEY, vector);
    }
}

