/*
 * Decompiled with CFR 0.152.
 */
package jade.proto.states;

import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class MsgReceiver
extends SimpleBehaviour {
    public static final int TIMEOUT_EXPIRED = -1001;
    public static final int INTERRUPTED = -1002;
    public static final int INFINITE = -1;
    private MessageTemplate template;
    private long deadline;
    private Object receivedMsgKey;
    private boolean received;
    private boolean expired;
    private boolean interrupted;
    private int ret;

    public MsgReceiver(Agent agent, MessageTemplate messageTemplate, long l, DataStore dataStore, Object object) {
        super(agent);
        this.setDataStore(dataStore);
        this.template = messageTemplate;
        this.deadline = l;
        this.receivedMsgKey = object;
        this.received = false;
        this.expired = false;
        this.interrupted = false;
    }

    protected MsgReceiver() {
    }

    public void action() {
        if (this.interrupted) {
            if (this.receivedMsgKey != null) {
                this.getDataStore().put(this.receivedMsgKey, null);
            }
            this.ret = -1002;
            return;
        }
        ACLMessage aCLMessage = this.myAgent.receive(this.template);
        if (aCLMessage != null) {
            if (this.receivedMsgKey != null) {
                this.getDataStore().put(this.receivedMsgKey, aCLMessage);
            }
            this.received = true;
            this.ret = aCLMessage.getPerformative();
            this.handleMessage(aCLMessage);
        } else if (this.deadline >= 0L) {
            long l = this.deadline - System.currentTimeMillis();
            if (l <= 0L) {
                if (this.receivedMsgKey != null) {
                    this.getDataStore().put(this.receivedMsgKey, null);
                }
                this.expired = true;
                this.ret = -1001;
                this.handleMessage(null);
            } else {
                this.block(l);
            }
        } else {
            this.block();
        }
    }

    public boolean done() {
        return this.received || this.expired || this.interrupted;
    }

    public int onEnd() {
        this.received = false;
        this.expired = false;
        this.interrupted = false;
        return this.ret;
    }

    protected void handleMessage(ACLMessage aCLMessage) {
    }

    public void reset(MessageTemplate messageTemplate, long l, DataStore dataStore, Object object) {
        super.reset();
        this.received = false;
        this.expired = false;
        this.interrupted = false;
        this.setTemplate(messageTemplate);
        this.setDeadline(l);
        this.setDataStore(dataStore);
        this.setReceivedKey(object);
    }

    public void setDeadline(long l) {
        this.deadline = l;
    }

    public void setTemplate(MessageTemplate messageTemplate) {
        this.template = messageTemplate;
    }

    public void setReceivedKey(Object object) {
        this.receivedMsgKey = object;
    }

    public void interrupt() {
        this.interrupted = true;
        this.restart();
    }
}

